@echo off %debug%

rem
rem Netzwerkeinstellungen speichern.cmd
rem
rem (c) 2006 Johannes Endres und c't
rem

rem In welchem Verzeichnis sollen die Einstellungen gespeichert werden?
rem In der Voreinstellung das Verzeichnis, in dem auch dieses Skript liegt
set _Verzeichnis_="%~dp0"

rem Welche Internet-Explorer-Einstellungen sollen mit gesichert werden?
rem Die sind die Namen der passenden Werte aus dem unten genannten Registry-Schlssel.
set _IEValues_=NoNetAutodial MigrateProxy ProxyEnable EnableAutodial ProxyServer ProxyOverride AutoConfigURL

rem Wo sind die Benutzereinstellungen des IE abgelegt?
rem Das ist nur in einer Variable, damit unten weniger Tipparbeit anfllt
set _IEKey_=HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Internet Settings

rem Um Tippfehler zu vermeiden, kommt der Temp-Dateiname in eine Variable
set _Temp_File_=%temp%\%~ns0_tmp.reg

rem Ist das Verzeichnis schon vorhanden?
if not exist %_Verzeichnis_%\... mkdir %_Verzeichnis_% 
if exist %_Verzeichnis_% goto Namen_finden
echo Konnte das Verzeichnis
echo %_Verzeichnis_%
echo nicht anlegen.
exit /b 1

:Namen_finden
rem Falls ein Parameter bergeben wurde, nehmen wir den als Namen fr die Konfiguration,
rem sonst fragen wir nach
set _Name_=%~1
if ""=="%~1" set /P _Name_="Wie soll diese Konfiguration heien? "
set _Name_=%_Verzeichnis_%\"%_Name_%".cmd

rem Wenn die Datei schon existiert, vor dem Ersetzen nachfragen
if not exist %_Name_% goto Vorlage_kopieren
set /p _yesno_="%_Name_% existiert bereits, berschreiben (j/n)? "
echo %_yesno_% | findstr /B /I "j" >nul
if errorlevel 1 goto Namen_finden
erase %_Name_%

rem Abbrechen, wenn die alte Datei nicht gelscht werden kann
if not exist %_Name_% goto Vorlage_kopieren
echo Konnte %_Name_% nicht lschen.
exit /b 1

:Vorlage_kopieren
rem Skript-Vorlage kopieren
rem Auch das geht natrlich mit dem im Artikel beschriebenen Trick
rem Hier kann "exit /b" nicht als Ende-Marker dienen, da es auch in der Skript-Vorlage vorkommt.
for /f "delims=:" %%i in ('findstr /N /X /C:"__VORLAGE__" %~s0') do set more=+%%i
more %~s0 >%_Name_%
set more=

rem Netzwerkkonfiguration per netsh dranhngen
netsh.exe interface ip dump >>%_Name_%

rem Der exit-Befehl mit anschlieendem Kommentar dient als Trenner zwischen netsh- und Internet-Explorer-Einstellungen
echo exit #netsh>>%_Name_%

rem IE-Einstellungen anhngen
rem  Zuerst den Anfang einer Registry-Datei an das neue Skript hngen
( echo REGEDIT4
  echo.
  echo [%_IEKey_%]
  )>>%_Name_%

rem --- von hier ---
rem   dann den Schlssel exportieren
regedit /a %_Temp_File_% "%_IEKey_%"

rem   dann die Befehle zum Lschen der Werte
for %%i in (%_IEValues_%) do echo "%%i"=->>%_Name_%

rem   schlielich nur die Proxy- und Einwahl-Einstellungen sichern
findstr "%_IEValues_%" %_Temp_File_% >>%_Name_%

rem   Temporre Datei lschen
erase %_Temp_File_%
rem --- bis hier fr die Einstellungen anderer Programme kopieren und anpassen ---

exit /b

__VORLAGE__
@echo off %debug%
setlocal
echo DHCP-Adressen freigeben
ipconfig /release >nul
echo Netzwerkkonfiguration setzen
for /f "delims=:" %%i in ('findstr /N /X /C:"exit /b" %~s0') do set more=+%%i
more %~s0 |netsh >nul
set more=
echo DHCP-Adressen neu beziehen
ipconfig /renew >nul
echo Proxy-Konfiguration setzen
for /f "delims=:" %%i in ('findstr /N /X /C:"exit #netsh" %~s0') do set more=+%%i
more %~s0 >%temp%\%~ns0_tmp.reg
set more=
regedit /s %temp%\%~ns0_tmp.reg
erase %temp%\%~ns0_tmp.reg
exit /b